
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

from scipy.stats import gaussian_kde

# Sample data for scientific domain (e.g., temperature readings)
sensor1_data = np.random.normal(loc=20, scale=1.5, size=1000)
sensor2_data = np.random.normal(loc=25, scale=1.5, size=1000)

# Compute density for each dataset
density1 = gaussian_kde(sensor1_data)
density2 = gaussian_kde(sensor2_data)
xs = np.linspace(15, 30, 300)
ys1 = density1(xs)
ys2 = density2(xs)
labels = ["Sensor 1", "Sensor 2"]
xlabel = "Density"
ylabel = "Temperature (°C)"
title = "Temperature Distribution from Two Sensors"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Fill between x for density regions
plt.fill_betweenx(xs, ys1, color="#FF5733", alpha=0.6, label=labels[0])
plt.fill_betweenx(xs, ys2, color="#FFC300", alpha=0.6, label=labels[1])

# Set labels and title
ax.set_ylim(15, 30)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
plt.grid(True, linestyle="--", alpha=0.7)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_34.pdf", bbox_inches="tight")
