
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

from scipy.stats import gaussian_kde

# Sample data - hourly energy output in MW
solar_data = np.random.normal(loc=50, scale=10, size=1000)  # Solar energy
wind_data = np.random.normal(loc=75, scale=15, size=1000)   # Wind energy

# Compute density for each dataset
density_solar = gaussian_kde(solar_data)
density_wind = gaussian_kde(wind_data)
xs = np.linspace(20, 120, 300)
ys_solar = density_solar(xs)
ys_wind = density_wind(xs)

# Labels
labels = ["Solar Energy Output", "Wind Energy Output"]
xlabel = "Density"
ylabel = "Energy Output (MW)"
title = "Energy Output Density Comparison"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Fill between x for density regions
plt.fill_betweenx(xs, ys_solar, color="#FFDD44", alpha=0.5, label=labels[0])
plt.fill_betweenx(xs, ys_wind, color="#77CCFF", alpha=0.5, label=labels[1])

# Set labels and title
ax.set_ylim(20, 120)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
plt.grid(True, linestyle="--")

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_35.pdf", bbox_inches="tight")
