# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation - Population Density Data
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(42)
cities = ['Beijing', 'Shanghai']
# Simulated population densities (people per square km)
population_density_A = np.random.normal(3000, 500, 300)
population_density_B = np.random.normal(1500, 400, 300)

# Combine data for density estimation
population_data_1 = population_density_A
population_data_2 = population_density_B

# Kernel Density Estimation (KDE) for the population density data
kde_population_1 = gaussian_kde(population_data_1, bw_method='scott')
kde_population_2 = gaussian_kde(population_data_2, bw_method='scott')

x_dens_population = np.linspace(min(min(population_data_1), min(population_data_2)), 
                                max(max(population_data_1), max(population_data_2)), 1000)
density_population_1 = kde_population_1(x_dens_population)
density_population_2 = kde_population_2(x_dens_population)

# Extracted variables for the density plot
xlabel_text = "Population Density (people/km²)"
ylabel_text = "Density"
title_text = "Density of Population in Different Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the density curves for population density data
ax.plot(x_dens_population, density_population_1, color='purple', lw=2, label='Beijing Density')
ax.fill_between(x_dens_population, density_population_1, color='purple', alpha=0.3)

ax.plot(x_dens_population, density_population_2, color='orange', lw=2, label='Shanghai Density')
ax.fill_between(x_dens_population, density_population_2, color='orange', alpha=0.3)

# Set labels and title
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
ax.set_title(title_text, fontsize=16)

# Customize plot border and ticks
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, linestyle=":", alpha=0.5)

# Adding a legend
ax.legend(loc='upper right')

# ===================
# Part 4: Saving Output for Density Plot
# ===================
plt.tight_layout()
plt.savefig("density_46.pdf", bbox_inches="tight")
