# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation - Social Media Activity Data
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(0)
time = np.linspace(0, 24, 240)
active_users = 1000 + 300 * np.sin(time / 3)
posts_created = 500 + 200 * np.cos(time / 4)
likes_given = 800 + 250 * np.sin(time / 2.5)

# Combine data for density estimation
activity_data_1 = active_users
activity_data_2 = posts_created
activity_data_3 = likes_given

# Kernel Density Estimation (KDE) for the social media activity data
kde_activity_1 = gaussian_kde(activity_data_1, bw_method='scott')
kde_activity_2 = gaussian_kde(activity_data_2, bw_method='scott')
kde_activity_3 = gaussian_kde(activity_data_3, bw_method='scott')

x_dens_activity = np.linspace(0, 1400, 1000)
density_activity_1 = kde_activity_1(x_dens_activity)
density_activity_2 = kde_activity_2(x_dens_activity)
density_activity_3 = kde_activity_3(x_dens_activity)

# Extracted variables for the density plot
xlabel_text = "Count"
ylabel_text = "Density"
title_text = "Density of Social Media Activity Over a Day"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 5))

# Plot the density curves for social media activity data
ax.plot(x_dens_activity, density_activity_1, color='blue', lw=2, label='Active Users Density')
ax.fill_between(x_dens_activity, density_activity_1, color='blue', alpha=0.3)

ax.plot(x_dens_activity, density_activity_2, color='green', lw=2, label='Posts Created Density')
ax.fill_between(x_dens_activity, density_activity_2, color='green', alpha=0.3)

ax.plot(x_dens_activity, density_activity_3, color='orange', lw=2, label='Likes Given Density')
ax.fill_between(x_dens_activity, density_activity_3, color='orange', alpha=0.3)

# Set labels and title
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
ax.set_title(title_text, fontsize=16)

# Customize plot border and ticks
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, linestyle=":", alpha=0.5)

# Adding a legend
ax.legend(loc='upper right')

# ===================
# Part 4: Saving Output for Density Plot
# ===================
plt.tight_layout()
plt.savefig("density_48.pdf", bbox_inches="tight")
