
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Generating new data representing energy measurements
energy_consumption = np.random.normal(loc=50, scale=10, size=1000)
energy_production = np.random.normal(loc=60, scale=12, size=1000)

# Extracted strings
title_text = "Density Distribution of Energy Measurements"
xlabel_text = "Energy (MWh)"
ylabel_text = "Density"
legend_label1 = "Energy Consumption"
legend_label2 = "Energy Production"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(12, 7))  # Adjusted for better readability

# Adding a line for the true distribution (assuming normal for illustration)
x = np.linspace(min(energy_consumption.min(), energy_production.min()), max(energy_consumption.max(), energy_production.max()), 300)
consumption_pdf = (1 / (np.sqrt(2 * np.pi) * 10)) * np.exp(-((x - 50) ** 2) / (2 * 10**2))
production_pdf = (1 / (np.sqrt(2 * np.pi) * 12)) * np.exp(-((x - 60) ** 2) / (2 * 12**2))
ax.plot(x, consumption_pdf, linestyle="--", linewidth=2, color="forestgreen", label=legend_label1)
ax.plot(x, production_pdf, linestyle="--", linewidth=2, color="royalblue", label=legend_label2)

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)

# Add title and labels
ax.set_title(title_text, fontsize=18)
ax.set_xlabel(xlabel_text, fontsize=16)
ax.set_ylabel(ylabel_text, fontsize=16)
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_51.pdf", bbox_inches="tight")
