
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Generating new data representing CPU speeds in GHz
cpu_speed1 = np.random.normal(loc=3.0, scale=0.5, size=1000)
cpu_speed2 = np.random.normal(loc=3.5, scale=0.6, size=1000)

# Extracted strings
title_text = "Density Distribution of CPU Speeds"
xlabel_text = "CPU Speed (GHz)"
ylabel_text = "Density"
legend_label1 = "CPU Model A"
legend_label2 = "CPU Model B"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(12, 7))  # Adjusted for better readability

# Adding a line for the true distribution
x = np.linspace(min(cpu_speed1.min(), cpu_speed2.min()), max(cpu_speed1.max(), cpu_speed2.max()), 300)
cpu_speed1_pdf = (1 / (np.sqrt(2 * np.pi) * 0.5)) * np.exp(-((x - 3.0) ** 2) / (2 * 0.5**2))
cpu_speed2_pdf = (1 / (np.sqrt(2 * np.pi) * 0.6)) * np.exp(-((x - 3.5) ** 2) / (2 * 0.6**2))
ax.plot(x, cpu_speed1_pdf, linestyle="--", linewidth=2, color='teal', label=legend_label1)
ax.plot(x, cpu_speed2_pdf, linestyle="--", linewidth=2, color='seagreen', label=legend_label2)

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)

# Add title and labels
ax.set_title(title_text, fontsize=18)
ax.set_xlabel(xlabel_text, fontsize=16)
ax.set_ylabel(ylabel_text, fontsize=16)
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_53.pdf", bbox_inches="tight")
