# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation - Monthly Sales Data
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(42)
products = ['iPhone 14 Pro', 'Segway Ninebot MAX G30', 'Sony WH-1000XM5 Noise Cancelling Headphones']
sales = [np.random.normal(loc=100 + i*20, scale=15, size=300) for i in range(3)]

# Combine all product sales data for density estimation
all_sales = np.concatenate(sales)

# Kernel Density Estimation (KDE) for the sales data
kde_sales = gaussian_kde(all_sales, bw_method='scott')
x_dens_sales = np.linspace(min(all_sales), max(all_sales), 1000)
density_sales = kde_sales(x_dens_sales)

# Extracted variables for the density plot
xlabel_text = "Monthly Sales"
ylabel_text = "Density"
title_text = "Density of Monthly Sales Across Different Products"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 5))

# Plot the density curve for sales data
ax.plot(x_dens_sales, density_sales, color='purple', lw=2, label='Sales Density')
ax.fill_between(x_dens_sales, density_sales, color='purple', alpha=0.3)

# Set labels and title
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
ax.set_title(title_text, fontsize=16)

# Customize plot border and ticks
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, linestyle=":", alpha=0.5)

# Adding a legend
ax.legend(loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_56.pdf", bbox_inches="tight")
