
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Create philosophical data
years = np.linspace(2000, 2020, 100)  # Years from 2000 to 2020
existential_adoption = np.exp(
    -0.004 * (years - 2005) ** 2
)  # Existential philosophy peaks around year 2005
analytical_adoption = np.exp(
    -0.004 * (years - 2015) ** 2
)  # Analytical philosophy peaks around year 2015

# Text variables
xlabel_text = "Year"
ylabel_text = "Adoption Rate"
title_text = "Adoption of Philosophical Thoughts Over the Years"
legend_existential = "Existential Adoption"
legend_analytical = "Analytical Adoption"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_location = "upper left"
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the data
ax.fill_between(
    years,
    existential_adoption,
    color="navy",
    edgecolor="darkblue",
    alpha=0.6,
    label=legend_existential,
)
ax.fill_between(
    years,
    analytical_adoption,
    color="forestgreen",
    edgecolor="darkgreen",
    alpha=0.6,
    label=legend_analytical,
)

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.set_xlabel(xlabel_text)
ax.set_ylabel(ylabel_text)
ax.set_title(title_text)
ax.set_ylim(0, 1)

# Add legend
ax.legend(loc=legend_location)

# Adding grid for better readability
ax.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_57.pdf", bbox_inches="tight")
