
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Set random seed for reproducibility
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(100)

# Generate sample data for call durations and message counts
call_duration = np.random.normal(loc=30, scale=10, size=500)
message_counts = np.random.normal(loc=100, scale=30, size=300)
comm_data = np.concatenate([call_duration, message_counts])
xs = np.linspace(0, 150, 300)

# Axes Limits and Labels
title = "KDE Plot of Communication Data Distribution"
xlabel_value = "Metrics (duration in minutes or message counts)"
ylabel_value = "Density"

xticks_values = [0, 25, 50, 75, 100, 125, 150]
xticklabels = ["0", "25", "50", "75", "100", "125", "150"]
yticks_values = [0, 0.005, 0.01, 0.015, 0.02]
yticklabels = ["0.0", "0.005", "0.01", "0.015", "0.02"]
xlim_values = [0, 150]
ylim_values = [0, 0.025]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Set the figure size
fig, ax = plt.subplots(figsize=(12, 6))

# Create the KDE plot with adjusted x-axis range
density = gaussian_kde(comm_data)
density.covariance_factor = lambda: 0.20
density._compute_covariance()
plt.fill_between(xs, density(xs), color="#b0e0e6", edgecolor="#4682b4")

ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels)

ax.set_yticks(yticks_values)
ax.set_yticklabels(yticklabels)

plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Set the title and labels
plt.title(title, fontsize=14, fontweight='bold')
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_63.pdf", bbox_inches="tight")
