
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(123)

# Generate new sample data for average daily screen time of different age groups
screen_time_children = np.random.normal(loc=2, scale=1, size=1000)  # Age 6-12
screen_time_teenagers = np.random.normal(loc=4, scale=1.5, size=1000)  # Age 13-17
screen_time_adults = np.random.normal(loc=5, scale=2, size=1000)  # Age 18-30

# Labels for the new data
labels = ["Age 6-12", "Age 13-17", "Age 18-30"]
avxlabel = "Average Screen Time"
xlabel = "Screen Time (hours per day)"
ylabel = "Density"
title = "Daily Screen Time Distribution by Age Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Define colors for the different age groups
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

# Plot the density plots
for data, color, label in zip(
    [screen_time_children, screen_time_teenagers, screen_time_adults], colors, labels
):
    density = gaussian_kde(data)
    xs = np.linspace(0, 10, 200)
    density.covariance_factor = lambda: 0.4
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.3, label=label)

# Plot the average screen time line
plt.axvline(x=3.67, color="purple", linestyle="--", linewidth=2, label=avxlabel)

# Set chart labels and title
ax.set_xlim(0, 10)
ax.set_xticks(np.arange(0, 11, 1))
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
plt.title(title)

# Show grid
plt.grid(True, linestyle="--", alpha=0.6)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_69.pdf", bbox_inches="tight")
