
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(123)

# Generate new sample data for online course completion rates of different age groups
completion_rate_young = np.random.normal(loc=70, scale=15, size=1000)  # Age 18-25
completion_rate_mid = np.random.normal(loc=65, scale=10, size=1000)  # Age 26-40
completion_rate_senior = np.random.normal(loc=60, scale=8, size=1000)  # Age 41-60

# Labels for the new data
labels = ["Age 18-25", "Age 26-40", "Age 41-60"]
avxlabel = "Average Completion Rate"
xlabel = "Completion Rate (%)"
ylabel = "Density"
title = "Online Course Completion Rates by Age Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Define colors for the different age groups
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

# Plot the density plots
for data, color, label in zip(
    [completion_rate_young, completion_rate_mid, completion_rate_senior], colors, labels
):
    density = gaussian_kde(data)
    xs = np.linspace(20, 100, 200)
    density.covariance_factor = lambda: 0.4
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.5, label=label)

# Plot the average completion rate line
plt.axvline(x=65, color="red", linestyle="--", linewidth=1.5, label=avxlabel)

# Set chart labels and title
ax.set_xlim(20, 100)
ax.set_xticks(np.arange(20, 101, 10))
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
plt.title(title)

# Show grid
plt.grid(True, linestyle="--", alpha=0.6)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_70.pdf", bbox_inches="tight")
