
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for sports scores
football_scores = np.random.normal(loc=75, scale=10, size=1500)
basketball_scores = np.random.normal(loc=85, scale=15, size=1500)
tennis_scores = np.random.normal(loc=90, scale=13, size=1500)
labels = ["Football Scores", "Basketball Scores", "Tennis Scores"]
avxlabel = "Target Score"
xlabel = "Player Scores"
ylabel = "Density"
title = "Density Plot of Player Scores Across Different Sports"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Plot the density plots
for data, color, label in zip(
    [football_scores, basketball_scores, tennis_scores],
    ["#2ca02c", "#ff7f0e", "#1f77b4"],  # Green, Orange, Blue
    labels,
):
    density = gaussian_kde(data)
    xs = np.linspace(40, 140, 200)
    density.covariance_factor = lambda: 0.5
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.3, label=label)

# Plot the target score line
plt.axvline(x=80.0, color="red", linestyle="--", label=avxlabel)

# Set labels and title (if any)
ax.set_xlim(40, 140)
ax.set_xticks(
    [40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140]
)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
plt.grid(True, linestyle="--", linewidth=0.7)

# Add legend
plt.legend(loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_72.pdf", bbox_inches="tight")
