
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(43)
# Sample data
poetry_scores = np.random.normal(loc=70, scale=10, size=1000)
prose_scores = np.random.normal(loc=85, scale=12, size=1000)

# Compute density for each dataset
density_poetry = gaussian_kde(poetry_scores)
density_prose = gaussian_kde(prose_scores)
xs = np.linspace(30, 130, 300)
ys_poetry = density_poetry(xs)
ys_prose = density_prose(xs)

# Labels and texts
labels = ["Poetry", "Prose"]
xlabel = "Readability Score"
ylabel = "Density"
title = "Distribution of Readability Scores in Poetry and Prose"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim = (30, 130)
grid_style = ":"

# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Fill between x for density regions
plt.fill_between(xs, ys_poetry, color="#ff9999", alpha=0.5, label=labels[0])
plt.fill_between(xs, ys_prose, color="#66b3ff", alpha=0.5, label=labels[1])

# Set labels and title (if any)
ax.set_xlim(xlim)
ax.set_xlabel(xlabel, fontsize=12, fontweight='bold')
ax.set_ylabel(ylabel, fontsize=12, fontweight='bold')
ax.set_title(title, fontsize=14, fontweight='bold')

# Show grid
plt.grid(True, linestyle=grid_style)

# Add legend
plt.legend(loc='upper right', fontsize=11, frameon=True, shadow=True)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_75.pdf", bbox_inches="tight")
