
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(43)
# Sample data - Sports Domain
basketball_scores = np.random.normal(loc=75, scale=10, size=1000)
soccer_scores = np.random.normal(loc=60, scale=15, size=1000)

# Compute density for each dataset
density_basketball = gaussian_kde(basketball_scores)
density_soccer = gaussian_kde(soccer_scores)
xs = np.linspace(20, 130, 300)
ys_basketball = density_basketball(xs)
ys_soccer = density_soccer(xs)

# Labels and texts
labels = ["Basketball", "Soccer"]
xlabel = "Score"
ylabel = "Density"
title = "Distribution of Scores in Basketball and Soccer"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim = (20, 130)
grid_style = "--"

# Create the figure and axis
fig, ax = plt.subplots(figsize=(12, 8))

# Fill between x for density regions
plt.fill_between(xs, ys_basketball, color="#1f77b4", alpha=0.5, label=labels[0])
plt.fill_between(xs, ys_soccer, color="#ff7f0e", alpha=0.5, label=labels[1])

# Set labels and title (if any)
ax.set_xlim(xlim)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
plt.grid(True, linestyle=grid_style)

# Add legend
plt.legend(loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_76.pdf", bbox_inches="tight")
