
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(42)
# Sample sports data
basketball_scores = np.random.normal(loc=75, scale=10, size=1000)
soccer_scores = np.random.normal(loc=70, scale=12, size=1000)

# Compute density for each dataset
density_basketball = gaussian_kde(basketball_scores)
density_soccer = gaussian_kde(soccer_scores)
xs = np.linspace(30, 110, 300)
ys_basketball = density_basketball(xs)
ys_soccer = density_soccer(xs)

# Labels and texts
labels = ["Basketball", "Soccer"]
xlabel = "Score"
ylabel = "Density"
title = "Distribution of Scores in Basketball and Soccer"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim = (30, 110)
grid_style = "--"

# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Fill between x for density regions
plt.fill_between(xs, ys_basketball, color="orange", alpha=0.4, label=labels[0])
plt.fill_between(xs, ys_soccer, color="blue", alpha=0.4, label=labels[1])

# Set labels and title (if any)
ax.set_xlim(xlim)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14, fontweight='bold')

# Show grid
plt.grid(True, linestyle=grid_style, linewidth=0.5)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_77.pdf", bbox_inches="tight")
