
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define regions as groups
regions = [
    "North America",
    "Europe",
    "Asia",
    "South America",
    "Africa",
    "Australia",
    "Central America",
    "Middle East",
    "Southeast Asia",
    "Scandinavia",
]

# Tourism data: Number of Tourists (solid_bar) and Tourist Expenditure (striped_bar)
num_tourists = np.random.rand(10) * 15 + 5  # Number of tourists in millions, ranging from 5 to 20 million
tourist_expenditure = np.random.rand(10) * 6 + 2  # Expenditure in billion USD, ranging from 2 to 8 billion

# Errors for both metrics
tourist_errors = np.random.rand(10) * 1.5 + 0.5  # Error bars for tourist numbers
expenditure_errors = np.random.rand(10) * 1 + 0.5  # Error bars for expenditure

# Labels and Plot Types
label_Num_Tourists = "Number of Tourists (Millions)"
label_Tourist_Expenditure = "Tourist Expenditure (Billion USD)"

# Axes Limits and Labels
ylabel_value = "Value"
title = "Tourism Metrics by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(12, 7))

# X-axis positions for the bars
x = np.arange(len(regions))

# Create vertical stacked bar chart
ax.bar(
    x,
    num_tourists,
    color="#2a9d8f",
    yerr=tourist_errors,
    label=label_Num_Tourists,
    capsize=3,
)
ax.bar(
    x,
    tourist_expenditure,
    bottom=num_tourists,
    color="#f4a261",
    yerr=expenditure_errors,
    label=label_Tourist_Expenditure,
    capsize=3,
)

# Add labels and title
ax.set_ylabel(ylabel_value)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(regions, rotation=45, ha="right")
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorbar_100.pdf", bbox_inches="tight")
