
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Define regions as groups
regions = [
    "Paris",
    "New York City",
    "Tokyo",
    "Barcelona",
    "Dubai",
    "Rome",
    "Sydney",
    "Bangkok",
    "Istanbul",
    "London",
]

# Tourism data: Average Annual Visitors (millions) and Average Visitor Spending (billions)
annual_visitors = (
    np.random.rand(10) * 5 + 15
)  # Visitors ranging from 15 to 20 million
visitor_spending = (
    np.random.rand(10) * 3 + 5
)  # Spending ranging from 5 to 8 billion USD

# Errors for both metrics
visitor_errors = np.random.rand(10) * 1 + 0.5  # Error bars for visitor numbers
spending_errors = np.random.rand(10) * 0.5 + 0.5  # Error bars for spending

# Labels and Plot Types
label_Annual_Visitors = "Average Annual Visitors (Million)"
label_Visitor_Spending = "Average Visitor Spending (Billion USD)"

# Axes Limits and Labels
ylabel_value = "Value"
title = "Tourism Metrics by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(12, 7))

# X-axis positions for the bars
x = np.arange(len(regions))

# Create vertical stacked bar chart
color_visitors = "#ff9999"  # Light Coral
color_spending = "#66b3ff"  # Light Sky Blue

ax.bar(
    x,
    annual_visitors,
    color=color_visitors,
    yerr=visitor_errors,
    label=label_Annual_Visitors,
    capsize=5,
    edgecolor='black'
)
ax.bar(
    x,
    visitor_spending,
    bottom=annual_visitors,
    color=color_spending,
    yerr=spending_errors,
    label=label_Visitor_Spending,
    capsize=5,
    edgecolor='black'
)

# Add labels and title
ax.set_ylabel(ylabel_value)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(regions, rotation=45, ha="right")
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorbar_102.pdf", bbox_inches="tight")
