
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the bar charts
genres = ["Fiction", "Non-Fiction", "Mystery", "Sci-Fi"]
avg_reading_time = [5.2, 7.4, 6.1, 4.5]  # Average reading time in hours
comprehension_rate = [78, 84, 80, 75]  # Comprehension rate in percentage
error_reading_time = [0.5, 0.4, 0.6, 0.3]  # Error values for reading time
error_comprehension = [3, 4, 3, 2]  # Error values for comprehension rate
x = np.arange(len(avg_reading_time))  # x-coordinates for the bars
labels = ["Average Reading Time (hrs)", "Comprehension Rate (%)"]
title = "Comparison of Reading Time and Comprehension Across Genres"
ylims = [[0, 8], [70, 90]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax1 = plt.subplots(figsize=(10, 6))
# Bar width
width = 0.35

# Plotting 'avg_reading_time' on the primary y-axis
bars1 = ax1.bar(
    x - width / 2,
    avg_reading_time,
    width,
    label=labels[0],
    color="#8da0cb",
    yerr=error_reading_time,
    capsize=5,
    edgecolor="black",
)

# Create the secondary y-axis for 'comprehension_rate'
ax2 = ax1.twinx()
bars2 = ax2.bar(
    x + width / 2,
    comprehension_rate,
    width,
    label=labels[1],
    color="#66c2a5",
    yerr=error_comprehension,
    capsize=5,
    edgecolor="black",
)

# Adding annotations directly on the bars for clarity
for i, bar in enumerate(bars1):
    height = bar.get_height()
    label_x_pos = bar.get_x() + bar.get_width() / 2
    ax1.text(
        label_x_pos,
        height - error_reading_time[i] - 0.3,
        f"{height} hrs",
        rotation=90,
        ha="center",
        va="bottom" if height < 0 else "top",
    )
for j, bar in enumerate(bars2):
    height = bar.get_height()
    label_x_pos = bar.get_x() + bar.get_width() / 2
    ax2.text(
        label_x_pos,
        height - error_comprehension[j] - 1,
        f"{height}%",
        rotation=90,
        ha="center",
        va="bottom" if height < 0 else "top",
    )


fig.suptitle(title)
# Adding labels, title, and custom x-axis tick labels
ax1.set_ylabel(labels[0], color="#8da0cb")
ax2.set_ylabel(labels[1], color="#66c2a5")
ax1.set_xticks(x)
ax1.set_xticklabels(genres)

# Add a horizontal line at y=0 if needed
ax1.axhline(0, color="grey", linewidth=0.8)

# Adjusting y-axis limits to fit the annotations and errors
ax1.set_ylim(ylims[0])
ax2.set_ylim(ylims[1])

# Adding grid lines for better readability
ax1.yaxis.grid(linestyle="--", linewidth="0.5", color="grey")
ax1.set_axisbelow(True)

ax2.yaxis.grid(linestyle="--", color="grey")
ax2.set_axisbelow(True)
# Adding legend
fig.legend(loc="upper center", bbox_to_anchor=(0.5, 1.05), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("errorbar_105.pdf", bbox_inches="tight")
