
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for different transportation services
categories = [
    "Public Transport",
    "Taxi Service",
    "Ride Sharing",
    "Bike Sharing",
    "Car Rental",
    "Airport Shuttle",
    "Train Service",
]

# Percentage scores for customer satisfaction
satisfaction_scores = [
    70,
    60,
    65,
    75,
    68,
    73,
    80,
]

# Negative values for complaint rates
complaint_rates = [
    -20,
    -35,
    -25,
    -15,
    -22,
    -18,
    -12,
]

# Error data for each category
satisfaction_errors = [6, 5, 6, 4, 5, 4, 3]
complaint_errors = [3, 5, 4, 2, 3, 2, 1]

# Labels and Texts
xlabel = "Percentage"
ylabel = "Services"
title = "Customer Satisfaction and Complaint Rates in Transportation"
legend_labels = ["Complaint Rates", "Satisfaction Scores"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define colors
satisfaction_colors = [
    "#ff9999",
    "#66b3ff",
    "#99ff99",
    "#ffcc99",
    "#c2c2f0",
    "#ffb366",
    "#ffb3e6",
]

complaint_colors = [
    mcolors.to_rgba(color, alpha=0.6) for color in satisfaction_colors
]

# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 7))  # Adjusted size for clarity

# Plot horizontal bar charts with error bars
ax.barh(
    categories,
    complaint_rates,
    color=complaint_colors,
    edgecolor="black",
    xerr=complaint_errors,
    label=legend_labels[0],
    capsize=3,
)
ax.barh(
    categories,
    satisfaction_scores,
    left=0,
    color=satisfaction_colors,
    edgecolor="black",
    xerr=satisfaction_errors,
    label=legend_labels[1],
    capsize=3,
)

# Adding labels within bars for values
for i, (com_val, sat_val) in enumerate(zip(complaint_rates, satisfaction_scores)):
    ax.text(com_val / 2, i, f"{abs(com_val)}%", va="center", ha="center", color="gray")
    ax.text(sat_val / 2, i, f"{sat_val}%", va="center", ha="center", color="gray")

# Customizing axis and layout
ax.tick_params(axis="y", which="both", left=False)
ax.set_xlim(min(complaint_rates) - 10, max(satisfaction_scores) + 10)
ax.set_xticks([])
ax.spines["left"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)
ax.axvline(0, color="black")  # Draw a vertical line at x=0 for separation

# Labels at the ends
ax.text(-20, len(categories), legend_labels[0], ha="right", va="bottom")
ax.text(80, len(categories), legend_labels[1], ha="left", va="bottom")

# Chart Title
ax.set_title(title, fontsize=16)

# Invert the y-axis for readability
ax.invert_yaxis()

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("errorbar_107.pdf", bbox_inches="tight")
