
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for different software tools categories
categories = [
    "Text Editor",
    "IDEs",
    "Version Control",
    "Issue Tracking",
    "Continuous Integration",
    "Code Review",
    "Documentation Tools",
]
satisfaction_scores = [
    70,
    85,
    80,
    78,
    82,
    75,
    88,
]  # Percentage scores for user satisfaction
complaint_rates = [
    -20,
    -15,
    -18,
    -16,
    -12,
    -19,
    -10,
]  # Negative values for complaint rates

# Error data for each category
satisfaction_errors = [4, 3, 5, 4, 3, 5, 2]
complaint_errors = [3, 2, 3, 2, 1, 3, 1]

# Text labels
xlabel = "Percentage"
ylabel = "Tool Categories"
title = "User Satisfaction and Complaint Rates for Software Tools"
legend_labels = ["Complaint Rates", "Satisfaction Scores"]


# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusted size for clarity

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot horizontal bar charts with error bars
# Color Scheme
satisfaction_colors = [
    "#1b9e77",
    "#d95f02",
    "#7570b3",
    "#e7298a",
    "#66a61e",
    "#e6ab02",
    "#a6761d",
]

complaint_colors = [
    mcolors.to_rgba(color, alpha=0.6) for color in satisfaction_colors
]  # Slightly lighter for complaints


ax.barh(
    categories,
    complaint_rates,
    color=complaint_colors,
    edgecolor="darkgray",
    xerr=complaint_errors,
    label=legend_labels[0],
    capsize=5,
)
ax.barh(
    categories,
    satisfaction_scores,
    left=0,
    color=satisfaction_colors,
    edgecolor="darkgray",
    xerr=satisfaction_errors,
    label=legend_labels[1],
    capsize=5,
)

# Adding labels within bars for values
for i, (com_val, sat_val) in enumerate(zip(complaint_rates, satisfaction_scores)):
    ax.text(com_val / 2, i, f"{abs(com_val)}%", va="center", ha="center", color="black")
    ax.text(sat_val / 2, i, f"{sat_val}%", va="center", ha="center", color="black")

# Customizing axis and layout
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.tick_params(axis="y", which="both", left=False)  # Remove y-axis tick marks
ax.set_xlim(min(complaint_rates) - 10, max(satisfaction_scores) + 10)
ax.set_xticks([])
ax.spines["left"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)
ax.axvline(0, color="black")  # Draw a vertical line at x=0 for separation

# Labels at the ends
ax.text(-25, 7, legend_labels[0], ha="right", va="bottom")
ax.text(90, 7, legend_labels[1], ha="left", va="bottom")

# Invert the y-axis for readability
ax.invert_yaxis()

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("errorbar_108.pdf", bbox_inches="tight")
