
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
# Data for different service categories
categories = [
    "User Interface",
    "Performance",
    "Features",
    "Security",
    "Support",
    "Documentation",
    "Price",
]
satisfaction_scores = [
    85,
    88,
    90,
    92,
    86,
    79,
    77,
]  # Percentage scores for customer satisfaction
complaint_rates = [
    -10,
    -12,
    -8,
    -7,
    -15,
    -20,
    -18,
]  # Negative values for complaint rates

# Error data for each category
satisfaction_errors = [3, 2, 4, 2, 3, 4, 5]
complaint_errors = [2, 1, 3, 2, 2, 3, 2]

# Labels and text for chart
xlabel = 'Product Aspects'
ylabel = 'Percentage (%)'
title = 'Customer Feedback on Tech Product Aspects'
textlabels = ["Complaints", "Satisfaction"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(12, 8))  # Adjusted size for clarity

# Define colors
satisfaction_colors = [
    "#6a0dad",  # Purple
    "#6495ed",  # CornflowerBlue
    "#20b2aa",  # LightSeaGreen
    "#ff6347",  # Tomato
    "#ffd700",  # Gold
    "#dda0dd",  # Plum
    "#90ee90",  # LightGreen
]
complaint_colors = [
    mcolors.to_rgba(color, alpha=0.7) for color in satisfaction_colors
]  # Slightly lighter for complaints

# Plot vertical bar charts with error bars
ax.bar(
    categories,
    complaint_rates,
    color=complaint_colors,
    edgecolor="black",
    yerr=complaint_errors,
    capsize=5,
)
ax.bar(
    categories,
    satisfaction_scores,
    bottom=0,
    color=satisfaction_colors,
    edgecolor="black",
    yerr=satisfaction_errors,
    capsize=5,
)

# Adding labels within bars for values
for i, (com_val, sat_val) in enumerate(zip(complaint_rates, satisfaction_scores)):
    ax.text(i, com_val / 2, f"{abs(com_val)}%", va="center", ha="center", color="black")
    ax.text(i, sat_val / 2, f"{sat_val}%", va="center", ha="center", color="black")

# Customizing axis and layout
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.tick_params(axis="x", which="both", bottom=False)  # Remove x-axis tick marks

# Draw a horizontal line at y=0 for separation
ax.axhline(0, color="black", linewidth=0.8)

# Adding labels at the ends of y-axis
ax.text(-0.5, -25, textlabels[0], ha="right", va="bottom", rotation="vertical", fontsize=12)
ax.text(-0.5, 25, textlabels[1], ha="right", va="bottom", rotation="vertical", fontsize=12)

# Add grid lines for better readability
ax.grid(True, linestyle='--', alpha=0.7)

# Remove unnecessary spines
ax.spines["left"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorbar_111.pdf", bbox_inches="tight")
