
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
# Education Data for three schools
metrics = ["Test Scores", "Graduation Rate", "Student Satisfaction"]
values = np.array(
    [
        [85, 95, 92],  # School A
        [78, 88, 85],  # School B
        [82, 90, 88],  # School C
    ]
)

# Asymmetric error values for the education data
errors = np.array(
    [
        [[5, 3], [2, 2], [3, 2]],  # Errors for School A (lower, upper)
        [[4, 2], [3, 3], [4, 2]],  # Errors for School B
        [[3, 3], [2, 5], [3, 4]],  # Errors for School C
    ]
)

# Creating subplots for each school
schools = ["School A", "School B", "School C"]

ylabel = "Performance Metrics"
ylim = [70, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(1, 3, figsize=(12, 5))  # Enlarged figure layout

# Function to plot each school's data
def plot_school_data(ax, errors, school_index, school_name):
    x = np.arange(len(metrics))  # the label locations
    bar_colors = ["#4daf4a", "#ff7f00", "#377eb8"]
    barerrors = np.array(errors).T[:, :, school_index]
    bars = ax.bar(x, values[school_index], yerr=barerrors, color=bar_colors, capsize=7)
    for bar, lower_error, upper_error in zip(bars, barerrors[0], barerrors[1]):
        # Position for lower error text
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            bar.get_height() - lower_error - 3,
            f"-{lower_error}",
            va="bottom",
            ha="center",
            color="black",
        )
        # Position for upper error text
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            bar.get_height() + upper_error + 1,
            f"+{upper_error}",
            ha="center",
            color="black",
        )

    ax.set_title(school_name)
    ax.set_xticks(x)
    ax.set_xticklabels(metrics, rotation=45, ha="right")
    ax.set_ylabel(ylabel)
    ax.set_ylim(ylim)  # Uniform scale for all charts

for i, school in enumerate(schools):
    plot_school_data(axs[i], errors, i, school)

# ===================
# Part 4: Saving Output
# ===================
plt.suptitle("Education Performance Metrics by School", fontsize=16)
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("errorbar_117.pdf", bbox_inches="tight")
