
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data setup
import numpy as np

np.random.seed(0)

# Cities and X-axis points
cities = ["City A", "City B", "City C", "City D"]
x = np.arange(len(cities))

# Population data for two age groups in different cities
# These are fabricated values for demonstration
children_population = np.array([15000, 17000, 14000, 16000])  # Children population
adult_population = np.array([50000, 52000, 48000, 51000])  # Adult population

# Errors for both metrics
children_population_errors = np.array([1000, 1500, 1200, 1100])
adult_population_errors = np.array([2000, 2500, 2200, 2100])

# Labels for the data series
labels = ["Children Population", "Adult Population"]
ylabels = ["Children Population", "Adult Population"]

# Other text labels and titles
title = "Population Statistics Across Cities"
ylims = [[10000, 20000], [40000, 60000]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting setup
fig, ax1 = plt.subplots(figsize=(8, 5))

# Bar width and hatch patterns
width = 0.35
hatch_patterns = ["//", "\\"]

# Colors for the bars
colors = ["#4CAF50", "#2196F3"]  # Green and blue shades

# Plot data on the left y-axis (children population)
ax1.bar(
    x,
    children_population,
    width,
    color=colors[0],
    hatch=hatch_patterns[0],
    label=labels[0],
    yerr=children_population_errors,
    capsize=5,
    edgecolor="black",
)

# Create a second y-axis sharing the same x-axis (adult population)
ax2 = ax1.twinx()
ax2.bar(
    x + width,
    adult_population,
    width,
    color=colors[1],
    hatch=hatch_patterns[1],
    label=labels[1],
    yerr=adult_population_errors,
    capsize=5,
    edgecolor="black",
)

# Set the x-ticks to be in the middle of the two bars and add the labels
ax1.set_xticks(x + width / 2)
ax1.set_xticklabels(cities)

# Add a legend
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

# Set labels for y-axes
ax1.set_ylabel(ylabels[0], color=colors[0])
ax2.set_ylabel(ylabels[1], color=colors[1])

# Set colors for y-axes
ax1.tick_params(axis="y", colors=colors[0])
ax2.tick_params(axis="y", colors=colors[1])

# Set the limits for y-axes to fit the data
ax1.set_ylim(ylims[0])
ax2.set_ylim(ylims[1])

# Set title for the chart
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_119.pdf", bbox_inches="tight")
