
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Data
societal_groups = [
    "Youth",
    "Adults",
    "Elderly",
    "Students",
    "Workers",
    "Retirees",
    "Unemployed",
    "Homemakers",
    "Parents",
    "Singles",
]
happiness_index = [
    7.5,
    6.8,
    6.3,
    7.0,
    6.7,
    6.5,
    5.8,
    6.2,
    7.1,
    6.6,
]
errors = [0.3] * 10  # Assuming constant error for all bars
legendtitle = ["High Happiness", "Moderate Happiness"]
ylabel = "Average Happiness Index ↑"
xlabel = "Societal Groups"
title = "Happiness Index Across Different Societal Groups"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0", "#ffb3e6", "#c4e17f", "#76d7c4", "#ff7f50", "#8e44ad"]
fig, ax = plt.subplots(figsize=(8, 6))
bars = ax.bar(
    societal_groups,
    happiness_index,
    yerr=errors,
    color=colors,
    capsize=10,
    error_kw={
        "ecolor": "darkgray",
        "elinewidth": 2,
        "capsize": 5,
        "capthick": 2,
    },
)

# Annotate bars with happiness index values
for bar, happiness, error, group in zip(bars, happiness_index, errors, societal_groups):
    ax.text(
        bar.get_x() + bar.get_width() / 2,
        bar.get_height() - error - 0.1,
        f"{happiness:.1f}",
        ha="center",
        va="bottom",
    )

# Legend setup
high_happiness_patch = mpatches.Patch(color="#ff9999", label=legendtitle[0])
moderate_happiness_patch = mpatches.Patch(color="#66b3ff", label=legendtitle[1])
ax.legend(handles=[high_happiness_patch, moderate_happiness_patch], loc="upper right", frameon=False)

# Labels and grid
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_ylim(5.00, 8.00)
ax.yaxis.grid(True)
ax.set_axisbelow(True)
plt.xticks(rotation=45, ha='right')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_32.pdf", bbox_inches="tight")
