
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
agri_methods = [
    "Organic",
    "Conventional",
    "No-Till",
    "Permaculture",
    "Agroforestry",
    "Hydroponics",
    "Biological",
    "Biodynamic",
    "Regenerative",
    "Precision Agri.",
]
crop_yields = [
    3.5,
    4.2,
    3.8,
    3.3,
    4.0,
    5.5,
    3.7,
    3.9,
    4.1,
    4.5,
]
errors = [0.2, 0.25, 0.2, 0.15, 0.2, 0.3, 0.2, 0.25, 0.2, 0.3]  
legendtitle = ["Traditional Methods", "Modern Methods"]
ylabel = "Average Crop Yield (tons/ha) ↑"
xlabel = ""

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8cb369"] * 5 + ["#f4a261"] * 5
# Plot
fig, ax = plt.subplots(figsize=(8, 5))
bars = ax.bar(
    agri_methods,
    crop_yields,
    yerr=errors,
    color=colors,
    capsize=10,
    error_kw={
        "ecolor": "gray",
    },
)

# Annotate bars with crop yield values
for bar, yield_value, error, method in zip(bars, crop_yields, errors, agri_methods):
    ax.text(
        bar.get_x() + bar.get_width() / 2,
        bar.get_height() - error - 0.2,
        f"{yield_value:.1f}",
        ha="center",
        va="bottom",
        fontsize=10
    )
    # Add method name on the bar
    ax.text(
        bar.get_x() + bar.get_width() / 2, 0, method, ha="center", va="top", rotation=90, fontsize=10
    )

# Create patches for the legend
patch1 = mpatches.Patch(color="#8cb369", label=legendtitle[0])
patch2 = mpatches.Patch(color="#f4a261", label=legendtitle[1])

# Add legend
ax.legend(handles=[patch1, patch2], loc="upper right", frameon=False)

# Labels and grid
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_ylim(0, 6)

ax.yaxis.grid(True)
ax.set_axisbelow(True)

# Hide x-tick labels
ax.set_xticks([])
plt.tick_params(axis="x", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to match the original image's dimensions
plt.tight_layout()
plt.savefig("errorbar_33.pdf", bbox_inches="tight")
