
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for energy efficiency parameters (replace with actual values)
groups = [
    "Solar / High / Day",
    "Solar / High / Night",
    "Solar / Medium / Day",
    "Solar / Medium / Night",
    "Solar / Low / Day",
    "Solar / Low / Night",
    "Wind / High / Day",
    "Wind / High / Night",
    "Wind / Medium / Day",
    "Wind / Medium / Night",
    "Wind / Low / Day",
    "Wind / Low / Night",
    "Hydro / High / Day",
    "Hydro / High / Night",
    "Hydro / Medium / Day",
    "Hydro / Medium / Night",
    "Hydro / Low / Day",
    "Hydro / Low / Night",
]
solid_bar_values = np.random.rand(18) * 0.3 + 0.7  # Simulated efficiency values (70%-100%)
striped_bar_values = np.random.rand(18) * 0.3 + 0.6  # Simulated efficiency values (60%-90%)
error = np.random.rand(18) * 0.05  # Simulated error values

# Labels and Plot Types
label_Striped = "Predicted Efficiency"
label_Solid = "Actual Efficiency"

# Axes Limits and Labels
xlabel_value = "Efficiency (%)"
ylabel_value = "Energy Systems / Conditions"
title = "Energy Systems Efficiency Analysis"
ylim_values = [-0.4, 17.4]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(12, 10))

# Create grouped bar chart with error bars
bar_width = 0.4
index = np.arange(len(groups))
plt.barh(
    index - 0.2,
    striped_bar_values,
    bar_width,
    color="#88c999",
    hatch="//",
    xerr=error,
    label=label_Striped,
    capsize=5,
    edgecolor="black",
    alpha=0.7,
)
plt.barh(
    index + 0.2,
    solid_bar_values,
    bar_width,
    color="#5171a5",
    hatch="\\\\",
    xerr=error,
    label=label_Solid,
    capsize=5,
    edgecolor="black",
    alpha=0.7,
)

# Add labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title)
plt.yticks(index, groups, rotation=0)
plt.gca().set_ylim(ylim_values)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorbar_38.pdf", bbox_inches="tight")

