
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data (Tech Company Performance)
companies = [
    "Company A",
    "Company B",
    "Company C",
    "Company D",
    "Company E",
    "Company F",
    "Company G",
    "Company H",
    "Company I",
    "Company J",
    "Company K",
    "Company L",
    "Company M",
    "Company N",
    "Company O",
    "Company P",
    "Company Q",
    "Company R",
]
revenue_values = np.random.rand(18) * 1000  # Revenue in million dollars
profit_margin_values = np.random.rand(18) * 100  # Profit margin in percentage
error = np.random.rand(18) * 50

# Labels and Plot Types
label_Revenue = "Revenue (in million $)"
label_Profit = "Profit Margin (%)"

# Axes Limits and Labels
xlabel_value = "Financial Metrics"
ylabel_value = "Companies"
title = "Tech Company Performance"
ylim_values = [-0.4, 17.4]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(12, 10))

# Create grouped bar chart with error bars
bar_width = 0.4
index = np.arange(len(companies))

plt.barh(
    index - 0.2,
    revenue_values,
    bar_width,
    color="#2d7f5e",
    hatch="..",
    xerr=error,
    label=label_Revenue,
    capsize=3,
    edgecolor="black",
    alpha=0.8,
)
plt.barh(
    index + 0.2,
    profit_margin_values,
    bar_width,
    color="#de425b",
    hatch="xx",
    xerr=error,
    label=label_Profit,
    capsize=3,
    edgecolor="black",
    alpha=0.8,
)

# Add labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title)
plt.yticks(index, companies, rotation=0)
plt.gca().set_ylim(ylim_values)

# Add legend
plt.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorbar_39.pdf", bbox_inches="tight")
