
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# New Data for communication domain
roles = ["Speaker A", "Speaker B", "Listener", "Moderator", "Participant"]
duration_means = [90.5, 110.3, 60.4, 75.0, 88.6]
duration_errors = [12, 18, 8, 14, 9]
tokens_means = [430.2, 800.4, 520.1, 590.8, 610.3]
tokens_errors = [95, 130, 65, 110, 85]

# Labels and Titles
ylabel1 = "Duration (s)"
xlabel1 = "(a) Speak duration of roles"
ylabel2 = "Tokens"
xlabel2 = "(b) Speak tokens of roles"
suptitle = "Communication Role Analysis"
title1 = "Duration per Role"
title2 = "Tokens per Role"
legend_labels = ["Duration", "Tokens"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5))
colors = ["#4daf4a", "#377eb8", "#ff7f00", "#984ea3", "#e41a1c"]

# Speak duration of roles
ax1.bar(roles, duration_means, yerr=duration_errors, color=colors, capsize=5, alpha=0.7, edgecolor='black')
ax1.set_ylabel(ylabel1)
ax1.set_xlabel(xlabel1)
ax1.set_title(title1)
for i, v in enumerate(duration_means):
    ax1.text(i, v + duration_errors[i] + 2, str(v), ha="center", va="bottom")
ax1.spines["top"].set_visible(False)
ax1.spines["right"].set_visible(False)
ax1.yaxis.grid(True, linestyle='--', linewidth=0.7)
ax1.set_axisbelow(True)

# Speak tokens of roles
ax2.bar(roles, tokens_means, yerr=tokens_errors, color=colors, capsize=5, alpha=0.7, edgecolor='black')
ax2.set_ylabel(ylabel2)
ax2.set_xlabel(xlabel2)
ax2.set_title(title2)
for i, v in enumerate(tokens_means):
    ax2.text(i, v + tokens_errors[i] + 20, str(v), ha="center", va="bottom")
ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)
ax2.yaxis.grid(True, linestyle='--', linewidth=0.7)
ax2.set_axisbelow(True)

# Add super title
fig.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("errorbar_40.pdf", bbox_inches="tight")
