
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
periods = ["Q1 2021", "Q2 2021", "Q3 2021", "Q4 2021", "Q1 2022", "Q2 2022"]
samples = [
    "(120 samples)",
    "(150 samples)",
    "(180 samples)",
    "(200 samples)",
    "(220 samples)",
    "(250 samples)",
]
x = range(len(periods))
y = [52.5, 55.0, 53.2, 54.5, 56.3, 57.8]
errors = [3.0, 2.5, 2.8, 2.2, 2.0, 1.8]
ylabel = "Approval Rating (%)"
xlabel = "Time Period"
chart_title = "Political Leader Approval Ratings Over Time"
ylim = [40, 60]
yticks = np.arange(40, 61, 5)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the bar chart
fig, ax = plt.subplots(figsize=(10, 7))

bars = ax.bar(x, y, yerr=errors, color='#1f78b4', capsize=5, edgecolor='black', alpha=0.7)

# Adding data labels on top of the bars
for bar in bars:
    yval = bar.get_height()
    ax.text(
        bar.get_x() + bar.get_width() / 2,
        yval + 0.5,
        round(yval, 1),
        ha="center",
        va="bottom",
        fontsize=10,
        fontweight='bold'
    )

# Setting the x-axis labels with both periods and sample sizes
ax.set_xticks(x)
ax.set_xticklabels([f"{period}\n{sample}" for period, sample in zip(periods, samples)])

# Setting the y-axis label
ax.set_ylabel(ylabel, fontsize=12, fontweight='bold')

# Setting the x-axis label
ax.set_xlabel(xlabel, fontsize=12, fontweight='bold')

# Setting the title of the chart
ax.set_title(chart_title, fontsize=14, fontweight='bold')

# Adjusting y-axis range
ax.set_ylim(ylim)
ax.set_yticks(yticks)
ax.set_yticklabels([f"{int(tick)}%" for tick in yticks])

# Adding grid to the background
ax.grid(axis="y", alpha=0.7, linestyle='--', color="gray")

# Making the axis lines visible
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["bottom"].set_visible(True)
ax.spines["left"].set_visible(True)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_45.pdf", bbox_inches="tight")
