
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(0)

# Data for the left plot (Average Temperature)
left_categories = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
left_means = [5.2, 6.0, 10.3, 15.2, 20.0, 23.5, 25.2, 24.8, 20.3, 15.0, 10.2, 6.5]
left_errors = [1.0, 1.5, 1.0, 0.8, 0.9, 1.0, 1.2, 1.1, 0.9, 0.8, 1.0, 1.3]

# Data for the right plot (Precipitation)
right_categories = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
right_means = [60, 50, 70, 55, 80, 90, 100, 120, 110, 95, 85, 70]
right_errors = [5, 7, 6, 5, 8, 7, 9, 10, 8, 6, 7, 5]

# Titles and labels for the plots
title1 = "Average Temperature (°C)"
ylim1 = [0, 30]
yticks1 = np.arange(0, 31, 5)
title2 = "Average Precipitation (mm)"
ylim2 = [0, 140]
suptitle = "Monthly Weather Data"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Custom color scheme
colors = ["#1f78b4", "#33a02c", "#b2df8a", "#a6cee3", "#fb9a99", "#fdbf6f", "#cab2d6", "#6a3d9a", "#ff7f00", "#e31a1c", "#ffff99", "#b15928"]

# Left plot (Temperature)
ax1.bar(
    left_categories,
    left_means,
    yerr=left_errors,
    color=colors,
    capsize=5,
    error_kw=dict(ecolor="darkblue", lw=1.5, capsize=5, capthick=2),
)
ax1.set_title(title1)
ax1.set_ylim(ylim1)
ax1.set_yticks(yticks1)
ax1.set_xticklabels(left_categories, rotation=45, ha="right")
ax1.tick_params(axis="both", length=0)  # Hide tick marks
ax1.grid(True)
ax1.set_axisbelow(True)
for spine in ax1.spines.values():
    spine.set_color("gray")

# Right plot (Precipitation)
ax2.bar(
    right_categories,
    right_means,
    yerr=right_errors,
    color=colors,
    capsize=5,
    error_kw=dict(ecolor="darkgreen", lw=1.5, capsize=5, capthick=2),
)
ax2.set_title(title2)
ax2.set_ylim(ylim2)
ax2.set_xticklabels(right_categories, rotation=45, ha="right")
ax2.tick_params(axis="both", length=0)  # Hide tick marks
ax2.grid(True)
ax2.set_axisbelow(True)
for spine in ax2.spines.values():
    spine.set_color("gray")

# Set the title for the entire figure
fig.suptitle(suptitle)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("errorbar_46.pdf", bbox_inches="tight")
