
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the left plot (Crop Yield per Hectare)
left_categories = [
    "Wheat",
    "Corn",
    "Rice",
    "Barley",
    "Soybeans",
    "Cotton",
    "Potatoes",
    "Sugarcane",
    "Sorghum",
    "Oats",
]
left_means = [3.2, 4.5, 2.8, 3.0, 2.5, 1.8, 3.1, 8.0, 1.5, 2.2]
left_errors = [0.3, 0.4, 0.2, 0.3, 0.2, 0.1, 0.3, 0.5, 0.1, 0.2]

# Data for the right plot (Pest Infestation Levels)
right_categories = [
    "Wheat",
    "Corn",
    "Rice",
    "Barley",
    "Soybeans",
    "Cotton",
    "Potatoes",
    "Sugarcane",
    "Sorghum",
    "Oats",
]
right_means = [10, 5, 12, 8, 6, 3, 7, 15, 4, 9]
right_errors = [2, 1, 2, 2, 1, 1, 2, 3, 1, 2]

# Text labels and titles
title1 = "Crop Yield per Hectare (tons)"
ylim1 = [0, 9]
yticks1 = np.arange(0, 10, 1)
title2 = "Pest Infestation Levels (%)"
ylim2 = [0, 20]
suptitle = "Agriculture Data"
xlabel = "Crop Types"
ylabel1 = "Yield (tons/hectare)"
ylabel2 = "Infestation Level (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# Color palette
colors = ["#6b8e23", "#9acd32", "#556b2f", "#8fbc8f", "#228b22", "#32cd32", "#66cdaa", "#2e8b57", "#3cb371", "#adff2f"]

# Left plot
ax1.bar(
    left_categories,
    left_means,
    yerr=left_errors,
    color=colors,
    capsize=5,
    error_kw=dict(ecolor="black", lw=1, capsize=5, capthick=2),
)
ax1.set_title(title1)
ax1.set_ylim(ylim1)
ax1.set_yticks(yticks1)
ax1.set_xticklabels(left_categories, rotation=90, ha="center")
ax1.tick_params(axis="both", length=0)  # Hide tick marks
ax1.grid(True)
ax1.set_axisbelow(True)
ax1.set_ylabel(ylabel1)
for spine in ax1.spines.values():
    spine.set_color("gray")

# Right plot
ax2.bar(
    right_categories,
    right_means,
    yerr=right_errors,
    color=colors,
    capsize=5,
    error_kw=dict(ecolor="black", lw=1, capsize=5, capthick=2),
)
ax2.set_title(title2)
ax2.set_ylim(ylim2)
ax2.set_xticklabels(right_categories, rotation=90, ha="center")
ax2.tick_params(axis="both", length=0)  # Hide tick marks
ax2.grid(True)
ax2.set_axisbelow(True)
ax2.set_ylabel(ylabel2)

# Set the title for the entire figure
fig.suptitle(suptitle)

for spine in ax2.spines.values():
    spine.set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("errorbar_47.pdf", bbox_inches="tight")
