
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
categories = [
    "Accommodation",
    "Transport",
    "Food",
    "Sightseeing",
    "Shopping",
    "Guided Tours",
    "Nightlife",
    "Culture",
    "Overall Experience",
]
ground_truth_ratings = [85, 78, 90, 92, 74, 88, 80, 90, 87]
weak_labels_ratings = [80, 75, 85, 88, 70, 82, 78, 85, 83]
error = [5, 5, 6, 5, 4, 5, 5, 5, 4]

labels = ["Surveyed Ratings", "Online Reviews"]
xlabel = "Tourism Categories"
ylabel = "Satisfaction Ratings (%)"
title = "Comparison of Tourist Satisfaction Ratings"
ylim = [60, 100]
yticks = np.arange(60, 101, 10)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.subplots(figsize=(12, 6))
# Bar width
bar_width = 0.35

# X position of bars
r1 = np.arange(len(ground_truth_ratings))
r2 = [x + bar_width for x in r1]

# Create bars
plt.bar(
    r1,
    ground_truth_ratings,
    color="#4CAF50",  # Green color
    width=bar_width,
    label=labels[0],
    yerr=error,
    capsize=7,
)
plt.bar(
    r2,
    weak_labels_ratings,
    color="#FF9800",  # Orange color
    width=bar_width,
    label=labels[1],
    yerr=error,
    capsize=7,
)

# Add xticks on the middle of the group bars
plt.xticks([r + bar_width / 2 for r in range(len(ground_truth_ratings))], categories)

# Create legend & Show graphic
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend(frameon=False, loc="upper right")  # Remove legend background

# Set background color and grid
plt.gca().set_facecolor("#f5f5f5")
plt.grid(color="white", linestyle="-", linewidth=0.75, axis="y")
plt.gca().set_axisbelow(True)

# Set y-axis limits
plt.ylim(ylim)
plt.yticks(yticks)

for spine in plt.gca().spines.values():
    spine.set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_54.pdf", bbox_inches="tight")
