
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
quarters = [1, 2, 3, 4]
baseline = [50] * len(quarters)  # Average baseline revenue in millions
action_movies = [55, 52, 60, 58]
comedy_movies = [48, 50, 53, 51]
drama_movies = [45, 47, 49, 46]
sci_fi_movies = [62, 65, 70, 68]
errors = [2, 2.5, 3, 1.5]

# Labels and Plot Types
label1 = "Action Movies"
label2 = "Comedy Movies"
label3 = "Drama Movies"
label4 = "Sci-Fi Movies"
label_baseline = "Baseline Revenue"

# Axes Limits and Labels
xlabel_value = "Quarter of the Year"
ylabel_value = "Average Box Office Revenue (in millions)"
title = "Quarterly Box Office Revenue by Movie Genre"
xticklabels = ["Q1", "Q2", "Q3", "Q4"]
ylim_values = [40, 80]
yticks_values = np.arange(40, 81, 10)
legend_title = "Movie Genre"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted for the given dimensions
bar_width = 0.2
opacity = 0.8

bar1 = ax.bar(
    np.array(quarters) - 1.5 * bar_width,
    action_movies,
    bar_width,
    alpha=opacity,
    color="#ff9999",
    label=label1,
    yerr=errors,
    capsize=3,
)

bar2 = ax.bar(
    np.array(quarters) - 0.5 * bar_width,
    comedy_movies,
    bar_width,
    alpha=opacity,
    color="#66b3ff",
    label=label2,
    yerr=errors,
    capsize=3,
)

bar3 = ax.bar(
    np.array(quarters) + 0.5 * bar_width,
    drama_movies,
    bar_width,
    alpha=opacity,
    color="#99ff99",
    label=label3,
    yerr=errors,
    capsize=3,
)

bar4 = ax.bar(
    np.array(quarters) + 1.5 * bar_width,
    sci_fi_movies,
    bar_width,
    alpha=opacity,
    color="#ffcc99",
    label=label4,
    yerr=errors,
    capsize=3,
)

ax.plot(
    quarters,
    baseline,
    linestyle="--",
    color="black",
    linewidth=2,
    label=label_baseline,
)

ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title)
ax.set_xticks(quarters)
ax.set_xticklabels(xticklabels)
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.legend(loc="upper left", title=legend_title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_59.pdf", bbox_inches="tight")
