
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Data
parties = ["Party A", "Party B", "Party C"]
year_2018 = [0.55, 0.60, 0.45]
year_2019 = [0.58, 0.63, 0.47]
year_2020 = [0.60, 0.65, 0.50]
error = [0.03, 0.04, 0.05]

# Bar positions
x = np.arange(len(parties))
width = 0.25
labels = ["2018", "2019", "2020"]
xlabel = "Political Parties"
ylabel = "Approval Ratings"
title = "Approval Ratings by Political Party and Year"
legend_title = "Year"
ylim = [0.3, 0.8]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6))

# Bar plots
bars1 = ax.bar(
    x - width,
    year_2018,
    width,
    label=labels[0],
    color="#1f77b4",  # Blue
    hatch="\\",
    yerr=error,
    capsize=5,
    error_kw=dict(ecolor="black"),
)
bars2 = ax.bar(
    x,
    year_2019,
    width,
    label=labels[1],
    color="#ff7f0e",  # Orange
    hatch="//",
    yerr=error,
    capsize=5,
    error_kw=dict(ecolor="black"),
)
bars3 = ax.bar(
    x + width,
    year_2020,
    width,
    label=labels[2],
    color="#2ca02c",  # Green
    hatch="o",
    yerr=error,
    capsize=5,
    error_kw=dict(ecolor="black"),
)

# Adding text for labels, title, and custom x-axis tick labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(parties)
ax.set_ylim(ylim)  # Adjust y-axis scale
ax.legend(title=legend_title, loc="upper left", bbox_to_anchor=(1, 1))  # Move legend outside

# Adding the data labels on the bars
def add_labels(bars):
    for bar in bars:
        height = bar.get_height()
        ax.annotate(
            "{}".format(round(height, 2)),
            xy=(
                bar.get_x() + bar.get_width() / 2,
                height + error[bars.index(bar)],
            ),  # Adjust label position to be above error bars
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

add_labels(bars1)
add_labels(bars2)
add_labels(bars3)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_61.pdf", bbox_inches="tight")
