
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
companies = ["Company A", "Company B", "Company C"]
baseline1 = [150, 160, 155]
baseline2 = [145, 158, 153]
new_strategy = [155, 162, 158]
error = [5, 4, 6]

# Bar positions
x = np.arange(len(companies))
width = 0.25
labels = ["2020 Performance", "2021 Performance", "New Strategy"]
ylabel = "Average Stock Price (USD)"
title = "Stock Price Performance by Company"
ylim = [130, 170]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))

bars1 = ax.bar(
    x - width,
    baseline1,
    width,
    label=labels[0],
    color="#93c4f2",
    hatch="\\",
    yerr=error,
    capsize=5,
    error_kw=dict(ecolor="gray"),
)
bars2 = ax.bar(
    x,
    baseline2,
    width,
    label=labels[1],
    color="#76b041",
    hatch="//",
    yerr=error,
    capsize=5,
    error_kw=dict(ecolor="gray"),
)
bars3 = ax.bar(
    x + width,
    new_strategy,
    width,
    label=labels[2],
    color="#7f8c8d",
    hatch="o",
    yerr=error,
    capsize=5,
    error_kw=dict(ecolor="gray"),
)

# Adding text for labels, title, and custom x-axis tick labels
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xticks(x)
ax.set_xticklabels(companies)
ax.set_ylim(ylim)
ax.legend(loc="upper center", ncol=3, fontsize=10)

# Adding the data labels on the bars
def add_labels(bars):
    for bar in bars:
        height = bar.get_height()
        ax.annotate(
            "{}".format(round(height, 1)),
            xy=(bar.get_x() + bar.get_width() / 2, height + error[bars.index(bar)]),
            xytext=(0, 3),
            textcoords="offset points",
            ha="center",
            va="bottom",
            fontsize=10
        )

add_labels(bars1)
add_labels(bars2)
add_labels(bars3)

# Adding grid
ax.grid(True, which='both', linestyle='--', linewidth=0.5, color='gray', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_63.pdf", bbox_inches="tight")
