
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for health domain
categories = [
    "Treatment A \n(slow)",
    "Treatment B \nmedium",
    "Treatment C \n(fast)",
    "Standard \nTreatment",
][::-1]
subcategories = ["Side Effects", "Symptom Reduction", "Full Recovery", "Patient Satisfaction"][::-1]
values = [
    [0.70, 0.75, 0.80, 0.85],
    [0.65, 0.70, 0.78, 0.82],
    [0.60, 0.65, 0.68, 0.75],
    [0.55, 0.60, 0.65, 0.70],
]
errors = [
    [0.05, 0.04, 0.03, 0.02],
    [0.05, 0.03, 0.04, 0.03],
    [0.04, 0.05, 0.06, 0.04],
    [0.03, 0.04, 0.05, 0.05],
]
percentages = [
    "+10%",
    "+8%",
    "+5%",
    "+5%",
    "+8%",
    "+7%",
    "+6%",
    "+6%",
    "+12%",
    "+10%",
    "+7%",
    "+5%",
    "+15%",
    "+12%",
    "+10%",
    "+8%",
][::-1]
xlim = [0.5, 0.95]

# Text Configurations
xlabel = "Recovery Metrics"
ylabel = "Treatments"
title = "Impact of Different Treatments on Patient Recovery"
supertitle = "Health Domain: Patient Recovery Analysis"
legendlabels = ["Side Effects", "Symptom Reduction", "Full Recovery", "Patient Satisfaction"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, axes = plt.subplots(4, 1, figsize=(10, 10), sharex=True)
colors = ["#8BC34A", "#FFC107", "#03A9F4", "#E91E63"]

for i, ax in enumerate(axes):
    bars = ax.barh(subcategories, values[i][::-1], xerr=errors[i], color=colors, capsize=5, edgecolor='black')
    ax.set_yticklabels(subcategories)
    ax.set_xlim(xlim)
    ax.set_ylabel(categories[i])

    for j, v in enumerate(values[i][::-1]):
        ax.text(
            v + errors[i][j] + 0.01,
            j,
            percentages[i * 4 + j],
            color="black",
            va="center",
        )

# Super title and labels
fig.suptitle(supertitle, fontsize=14)
axes[-1].set_xlabel(xlabel)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("errorbar_69.pdf", bbox_inches="tight")
