
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
categories = ["Country A", "Country B", "Country C", "Country D", "Country E", "Country F", "Country G", "Country H", "Country I", "Country J"]
values = [2.3, 1.9, 3.1, -0.4, 2.6, 1.2, -1.5, 0.8, 3.0, -0.7]
errors = [0.3, 0.2, 0.4, 0.25, 0.3, 0.15, 0.2, 0.1, 0.35, 0.25]

# Axes Limits and Labels
ylabel_value = "Average Annual GDP Growth Rate (%)"
ylim_values = [-2, 4]
xlabel_value = "Countries"
title_value = "Average Annual GDP Growth Rates by Country"
legend_label = "GDP Growth Rate (with Error)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#1f77b4",
    "#ff7f0e",
    "#2ca02c",
    "#d62728",
    "#9467bd",
    "#8c564b",
    "#e377c2",
    "#7f7f7f",
    "#bcbd22",
    "#17becf",
]

# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Bar chart
bars = ax.bar(
    categories, values, yerr=errors, color=colors, capsize=5, edgecolor="black"
)

# Set labels
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_title(title_value, fontsize=14)

# Set x-axis limits and y-axis limits
ax.set_ylim(ylim_values)

# Add grid lines for y-axis
ax.yaxis.grid(True, linestyle='--', linewidth=0.7)

# Remove top and right spines
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# Add legend
ax.legend([bars], [legend_label], loc="upper left")

# Rotate x-ticks for better readability
plt.xticks(rotation=45, ha='right')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping of ylabel and title
plt.tight_layout()
plt.savefig("errorbar_70.pdf", bbox_inches="tight")
