
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data
players = ["Player A", "Player B", "Player C", "Player D", "Player E", "Player F", "Player G", "Player H", "Player I", "Player J"]
performance_change = [0.05, 0.07, 0.12, 0.09, 0.02, -0.03, -0.05, 0.04, 0.06, -0.02]
performance_errors = [0.02, 0.03, 0.04, 0.02, 0.01, 0.02, 0.01, 0.02, 0.02, 0.01]

# Axes Limits and Labels
ylabel_value = "Field Goal % Change\n(Compared to last season)"
ylim_values = [-0.06, 0.14]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#4c72b0",
    "#55a868",
    "#c44e52",
    "#8172b3",
    "#ccb974",
    "#64b5cd",
    "#8d8e8e",
    "#e17c7c",
    "#f08080",
    "#b0e57c",
]

# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Bar chart
bars = ax.bar(
    players, performance_change, yerr=performance_errors, color=colors, capsize=5, edgecolor="none", error_kw=dict(ecolor='black', lw=1)
)
ax.set_xticks([])
# Set labels
ax.set_ylabel(ylabel_value)

# Set x-axis limits and y-axis limits
ax.set_ylim(ylim_values)

# Remove top and right spines
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)

# Remove grid lines
ax.yaxis.grid(False)
ax.xaxis.grid(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping of ylabel
plt.tight_layout()
plt.savefig("errorbar_72.pdf", bbox_inches="tight")
