
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data
categories = ["Low Stress", "Moderate Stress", "High Stress"]
methods = ["Memory", "Attention", "Reasoning", "Problem-solving"]
performance = np.array([[75, 85, 80, 70], [65, 70, 72, 68], [55, 60, 65, 58]])
errors = np.array([[5, 3, 4, 6], [6, 5, 5, 7], [7, 6, 5, 6]])
ylim = [40, 90]
ylabel = "Performance (%)"
xlabel_template = "({label}) {category}"
legend_labels = methods

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Figure size 720x216 pixels
fig, axes = plt.subplots(1, 3, figsize=(10, 3))

# Custom colors
colors = ["#6a3d9a", "#b2df8a", "#33a02c", "#fb9a99"]

# Bar width
bar_width = 0.8

# Plotting bars
for i, ax in enumerate(axes):
    for j, method in enumerate(methods):
        ax.bar(
            j + 1.5 * i,
            performance[i, j],
            width=bar_width,
            color=colors[j],
            yerr=errors[i, j],
            capsize=5,
            label=method if i == 0 else "",
            edgecolor='black'  # Add edge color to bars for better visualization
        )

# Setting x-axis labels, y-axis limits, and titles
for i, ax in enumerate(axes):
    ax.set_xticks([])
    ax.set_ylim(ylim)
    ax.set_xlabel(xlabel_template.format(label=chr(97 + i), category=categories[i]))
    ax.set_ylabel(ylabel if i == 0 else "")
    ax.yaxis.grid(True)
    ax.set_axisbelow(True)
    ax.spines['top'].set_visible(False)
    ax.spines['right'].set_visible(False)

# Adding legend outside the plot
fig.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=len(methods))

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout and saving the figure
plt.tight_layout()
plt.savefig("errorbar_74.pdf", bbox_inches="tight")
