
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New dataset related to historical events and findings
groups = [
    "Ancient Egypt: 3000 - 332 BC",
    "Ancient Greece: 800 - 146 BC",
    "Roman Empire: 27 BC - 476 AD",
    "Middle Ages: 476 - 1492 AD",
    "Renaissance: 1400 - 1600 AD",
    "Industrial Revolution: 1760 - 1840 AD",
    "Modern Era: 1900 - Present",
]

solid_bar_values = np.random.rand(7) * 0.7
striped_bar_values = np.random.rand(7) * 0.5
error = np.random.rand(7) * 0.1 + 0.02
labels = ["Documented Occurrences", "Archaeological Findings"]
xlabel = "Number of Events"
ylabel = "Historical Periods"
title = "Historical Events and Findings"
xlim = [0, 1.2]
ylim = [-0.5, 6.5]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match updated data's visualization needs
plt.figure(figsize=(10, 6))

# Create grouped bar chart with error bars
bar_width = 0.8
index = np.arange(len(groups))
plt.barh(
    index,
    solid_bar_values,
    bar_width,
    color="#8c564b",  # A sepia tone
    xerr=error,
    label=labels[0],
    capsize=5,
    edgecolor="black",
)
plt.barh(
    index,
    striped_bar_values,
    bar_width,
    left=solid_bar_values,
    color="#e377c2",  # Another historically inspired tone
    xerr=error,
    label=labels[1],
    capsize=5,
    edgecolor="black",
)

# Add labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.yticks(index, groups, rotation=0)
plt.gca().set_xlim(xlim)
plt.gca().set_ylim(ylim)

# Adding legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_76.pdf", bbox_inches="tight")

