
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(1)

# Sample data (replace with actual values)
groups = [
    "Oil Painting / 1980s",
    "Digital Art / 2000s",
    "Watercolor / 1990s",
    "Sculpture / 1970s",
    "Ink Drawing / 1980s",
    "Photography / 2000s",
    "Mixed Media / 1990s",
    "Street Art / 2010s",
    "Installation / 2000s",
    "Conceptual Art / 1990s",
    "Pop Art / 1960s",
    "Surrealism / 1920s",
    "Impressionism / 1870s",
    "Abstract / 1940s",
]
solid_bar_values = np.random.rand(14) * 0.5
striped_bar_values = np.random.rand(14) * 0.5
error = np.random.rand(14) * 0.1 + 0.02

# Labels for the bars
labels = ["Traditional", "Modern"]
xlabel = "Popularity Metric"
ylabel = "Art Techniques / Decades"
title = "Popularity of Art Techniques Over Decades"
xlim = [0, 1.1]
ylim = [-0.4, 13.4]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(10, 8))

# Create grouped bar chart with error bars
bar_width = 0.8
index = np.arange(len(groups))

# Define colors for the bars
color_solid = "#4B0082"  # Indigo
color_striped = "#FF4500"  # Orange Red

# Plot bars
plt.barh(
    index,
    solid_bar_values,
    bar_width,
    color=color_solid,
    xerr=error,
    label=labels[0],
    capsize=3,
    edgecolor="black",
)
plt.barh(
    index,
    striped_bar_values,
    bar_width,
    left=solid_bar_values,
    color=color_striped,
    xerr=error,
    label=labels[1],
    capsize=3,
    edgecolor="black",
)

# Adjust legend and labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.yticks(index, groups, rotation=0)
plt.gca().set_xlim(xlim)
plt.gca().set_ylim(ylim)

# Custom legend
traditional_patch = mpatches.Patch(color=color_solid, label='Traditional')
modern_patch = mpatches.Patch(color=color_striped, label='Modern')
plt.legend(handles=[traditional_patch, modern_patch], loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_78.pdf", bbox_inches="tight")
