
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for philosophy domain
categories = ["United States", "Germany", "India", "Brazil", "Japan"]
values = [0.45, 0.35, 0.30, 0.25, 0.20]  # Percentage of philosophical works produced
errors = [0.05, 0.04, 0.03, 0.02, 0.01]

categories2 = ["United States", "Germany", "India", "Brazil", "Japan"]
values2 = [500, 400, 300, 250, 200]  # Number of philosophy graduates
errors2 = [50, 40, 30, 20, 15]

titles = ["Percentage of Philosophical Works Produced", "Number of Philosophy Graduates"]

xlabel = "Percentage"
xlabel2 = "Number of Graduates"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Custom color scheme
colors = ["#7B8D42", "#A1C298", "#B6C9A5", "#D1E8E4", "#9DB4AB"]

fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 8))

# Plot for the first data set
ax1.barh(categories, values, xerr=errors, color=colors, capsize=5, edgecolor="black")
ax1.set_xlabel(xlabel)
ax1.set_title(titles[0])
ax1.grid(True, linestyle='--', alpha=0.5)

# Plot for the second data set
ax2.barh(categories2, values2, xerr=errors2, color=colors, capsize=5, edgecolor="black")
ax2.set_xlabel(xlabel2)
ax2.set_title(titles[1])
ax2.grid(True, linestyle='--', alpha=0.5)

# Tight layout for better spacing
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("errorbar_79.pdf", bbox_inches="tight")
