
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Data for Tech Company Market Share
companies1 = ["Apple", "Samsung", "Microsoft", "Google", "Amazon"]
market_shares = [32.5, 24.8, 15.6, 18.3, 8.8]
market_share_errors = [1.5, 1.2, 1.0, 1.3, 0.9]

# Data for Annual Revenue Growth Rate
companies2 = ["Apple", "Samsung", "Microsoft", "Google", "Amazon"]
revenue_growth = [10.2, 8.4, 12.6, 9.3, 7.8]
revenue_growth_errors = [0.8, 0.6, 1.0, 0.7, 0.5]

# Titles for the charts
chart_titles = ["Tech Company Market Share", "Annual Revenue Growth Rate"]

# Labels for the axes
xlabel1 = "Market Share (%)"
xlabel2 = "Annual Growth Rate (%)"
ylabel = "Companies"

# Legend labels (if any customization needed)

# Colors for the bars
colors = ["#4c72b0", "#55a868", "#c44e52", "#8172b2", "#ccb974"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(8, 8))
ax1.barh(companies1, market_shares, xerr=market_share_errors, color=colors, capsize=5, edgecolor='gray')
ax2.barh(companies2, revenue_growth, xerr=revenue_growth_errors, color=colors, capsize=5, edgecolor='gray')

ax1.set_title(chart_titles[0])
ax2.set_title(chart_titles[1])

ax1.set_xlabel(xlabel1)
ax1.set_ylabel(ylabel)

ax2.set_xlabel(xlabel2)
ax2.set_ylabel(ylabel)

# Additional styles
ax1.grid(True, linestyle='--', alpha=0.6)
ax2.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_80.pdf", bbox_inches="tight")

