
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data: Popular Art Movements in the 20th Century
categories = ["Abstract Expressionism", "Cubism", "Surrealism", "Pop Art", "Dada"]
values = [0.75, 0.60, 0.55, 0.50, 0.35]
errors = [0.05, 0.04, 0.03, 0.02, 0.01]

# Data: Number of Famous Artists
categories2 = ["Abstract Expressionism", "Cubism", "Surrealism", "Pop Art", "Dada"]
values2 = [18, 12, 10, 14, 8]
errors2 = [2, 1.5, 1, 1.2, 0.8]

titles = ["Popularity of Art Movements in the 20th Century (%)", "Number of Famous Artists"]

# Text Labels
xlabel1 = "Percentage"
xlabel2 = "Number of Artists"
ylabel = "Art Movements"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#ff7f0e", "#2ca02c", "#1f77b4", "#d62728", "#9467bd"]  # Vibrant colors
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(8, 8))

# First subplot
ax1.barh(categories, values, xerr=errors, color=colors, capsize=5, edgecolor='black')
ax1.set_title(titles[0])
ax1.set_xlabel(xlabel1)
ax1.set_ylabel(ylabel)

# Second subplot
ax2.barh(categories2, values2, xerr=errors2, color=colors, capsize=5, edgecolor='black')
ax2.set_title(titles[1])
ax2.set_xlabel(xlabel2)
ax2.set_ylabel(ylabel)

# Improve layout
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("errorbar_81.pdf", bbox_inches="tight")
