
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data representing transportation performance for three different cities
categories = ["New York", "Los Angeles", "Chicago"]
metrics = [
    "Punctuality",
    "Passenger Satisfaction",
    "Coverage Area",
    "Cost Efficiency",
]
performance = np.array(
    [
        [85, 75, 90, 70],
        [80, 85, 88, 65],
        [78, 82, 85, 60],
    ]
)
errors = np.array(
    [
        [3, 5, 4, 6],
        [4, 6, 5, 7],
        [5, 6, 6, 8],
    ]
)
ylim = [50, 100]
ylabel = "Performance Percentage"
xlabel_suffix = "Transportation Metrics"
legend_labels = metrics
figure_title = "Transportation Performance Metrics in Major Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Figure size to match a 3x1 subplot layout
fig, axes = plt.subplots(3, 1, figsize=(10, 9), sharex=True)
# Colors, choosing a different palette to differentiate the plots
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Plotting bars
for i, ax in enumerate(axes):
    for j, metric in enumerate(metrics):
        ax.bar(
            j,
            performance[i, j],
            width=0.8,
            color=colors[j],
            yerr=errors[i, j],
            capsize=5,
            label=metric if i == 0 else "",
        )

    # Setting x-axis labels, y-axis limits, and titles
    ax.set_xticks(range(len(metrics)))
    ax.set_xticklabels(metrics, rotation=45)
    ax.set_ylim(ylim)
    ax.set_xlabel(f"({chr(97+i)}) {categories[i]}")
    ax.set_ylabel(ylabel)
    ax.yaxis.grid(True)
    ax.set_axisbelow(True)

# Adding a legend outside of the plot on top
fig.legend(legend_labels, loc="upper center", bbox_to_anchor=(0.5, 1.05), ncol=len(metrics))
plt.suptitle(figure_title, y=1.02)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to prevent overlap and ensure labels are visible
plt.tight_layout()
plt.savefig("errorbar_86.pdf", bbox_inches="tight")
