
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sports data for different players
players = ["Player A", "Player B", "Player C", "Player D"]
x = np.arange(len(players))  # Location of labels on the x-axis

# Simplified data arrays to two seasons per metric
goals = np.array(
    [np.random.uniform(5, 15, 4), np.random.uniform(5, 15, 4)]
).T  # Spring and Autumn goals
assists = np.array(
    [np.random.uniform(3, 10, 4), np.random.uniform(3, 10, 4)]
).T  # Spring and Autumn assists
tackles = np.array(
    [np.random.uniform(20, 50, 4), np.random.uniform(20, 50, 4)]
).T  # Spring and Autumn tackles
distance_covered = np.array(
    [np.random.uniform(8, 15, 4), np.random.uniform(8, 15, 4)]
).T  # Spring and Autumn distance covered (km)
# Errors for each season
goal_errors = np.array([np.random.randint(1, 3, 4), np.random.randint(1, 3, 4)]).T
assist_errors = np.array([np.random.randint(1, 2, 4), np.random.randint(1, 2, 4)]).T
tackle_errors = np.array([np.random.randint(2, 5, 4), np.random.randint(2, 5, 4)]).T
distance_errors = np.array([np.random.randint(0, 2, 4), np.random.randint(0, 2, 4)]).T

labels = ["Spring", "Autumn"]
titles = [
    "Goals Scored",
    "Assists Made",
    "Tackles",
    "Distance Covered (km)",
]
ylabels = ["Goals", "Assists", "Tackles", "Distance (km)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, axs = plt.subplots(2, 2, figsize=(12, 8))  # Adjusted to 2 rows and 2 columns
axs = axs.flatten()

# Define colors for each set of bars to keep the design cohesive and attractive
colors = [
    ["#ffa07a", "#ff4500"],  # Spring and Autumn for goals
    ["#add8e6", "#0000ff"],  # Spring and Autumn for assists
    ["#90ee90", "#008000"],  # Spring and Autumn for tackles
    ["#dda0dd", "#800080"],
]  # Spring and Autumn for distance covered

# Helper function to plot data
def plot_data(ax, j, data, errors, title, ylabel):
    for i in range(2):  # Adjusted to only two bars per player
        ax.bar(
            x + i * 0.2,
            data[:, i],
            yerr=errors[:, i],
            color=colors[j][i],
            label=labels[i],
            width=0.2,
            capsize=3,
        )
    ax.set_title(title)
    ax.set_xticks(x + 0.1)  # Adjust position to center the group
    ax.set_xticklabels(players)
    ax.set_ylabel(ylabel)
    ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=2)

# Plot each category of sports data
plot_data(axs[0], 0, goals, goal_errors, titles[0], ylabels[0])
plot_data(axs[1], 1, assists, assist_errors, titles[1], ylabels[1])
plot_data(axs[2], 2, tackles, tackle_errors, titles[2], ylabels[2])
plot_data(axs[3], 3, distance_covered, distance_errors, titles[3], ylabels[3])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_88.pdf", bbox_inches="tight")

