
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Economic data for different countries
categories = ["Canada", "UK", "France", "Japan", "Australia"][::-1]
gdp_growth = [-2.3, -4.1, -3.7, -2.8, -1.5][::-1]  # GDP Growth Rate (%)
gdp_error = [0.5, 0.7, 0.4, 0.6, 0.3][::-1]  # Error values for GDP Growth Rate

unemployment_rate = [5.1, 6.5, 7.8, 4.9, 3.6][::-1]  # Unemployment Rate (%)
unemployment_error = [0.6, 0.7, 0.8, 0.5, 0.4][::-1]  # Error values for Unemployment Rate
xlabels = ["GDP Growth Rate (%)", "Unemployment Rate (%)"]
titles = ["GDP Growth Rate by Country", "Unemployment Rate by Country"]
xlims = [[-5, 0], [0, 10]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart with subplots
fig, axes = plt.subplots(1, 2, figsize=(12, 6), sharey=True)  # Adjust figure size

# Setting colors for the bars
neg_colors = ["#ff9999"] * 5
pos_colors = ["#66b3ff"] * 5

# Plotting bars for negative values (GDP Growth Rate)
bars = axes[0].barh(
    categories,
    gdp_growth,
    color=neg_colors,
    edgecolor="black",
    height=0.5,
    xerr=gdp_error,
    capsize=5,
)
axes[0].set_xlabel(xlabels[0])
axes[0].set_title(titles[0])
axes[0].invert_yaxis()
axes[0].set_xlim(xlims[0])
axes[0].xaxis.grid(True, linestyle='--', linewidth=0.7)
axes[0].spines["top"].set_visible(False)
axes[0].spines["right"].set_visible(False)

# Plotting bars for positive values (Unemployment Rate)
bars2 = axes[1].barh(
    categories,
    unemployment_rate,
    color=pos_colors,
    edgecolor="black",
    height=0.5,
    xerr=unemployment_error,
    capsize=5,
)
axes[1].set_xlabel(xlabels[1])
axes[1].set_title(titles[1])
axes[1].invert_yaxis()
axes[1].set_xlim(xlims[1])
axes[1].xaxis.grid(True, linestyle='--', linewidth=0.7)
axes[1].spines["top"].set_visible(False)
axes[1].spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_92.pdf", bbox_inches="tight")
