
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Categories and values for different companies
companies = ["Company A", "Company B", "Company C", "Company D", "Company E"][::-1]
total_sales = [-8000, -12000, -11000, -7000, -5000][::-1]  # Total sales in million dollars
sales_error = [800, 950, 800, 950, 800][::-1]  # Error values for total sales

growth_rate = [5, 7, 4.5, 3, 2][::-1]  # Growth rate as percentage of previous year
growth_error = [0.5, 0.75, 0.65, 0.5, 0.55][::-1]  # Error values for growth rate
xlabels = ["Total Sales (Million $)", "Growth Rate (%)"]
titles = ["Total Sales by Company", "Growth Rate by Company"]
xlims = [[-13000, 0], [0, 10]]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart with subplots
fig, axes = plt.subplots(1, 2, figsize=(12, 8), sharey=True)  # Adjust figure size

# Setting colors for the bars
neg_colors = ["#FF9999"] * 5  # Warm red color for negative values
pos_colors = ["#98FB98"] * 5  # Cool green color for positive values

# Plotting bars for negative values (Total Sales)
bars = axes[0].barh(
    companies,
    total_sales,
    color=neg_colors,
    edgecolor="white",
    height=0.5,
    xerr=sales_error,
    capsize=3,
)
axes[0].set_xlabel(xlabels[0])
axes[0].set_title(titles[0], fontsize=14)
axes[0].invert_yaxis()
axes[0].set_xlim(xlims[0])
axes[0].xaxis.grid(True, linestyle='--', linewidth=0.7)
axes[0].spines["top"].set_visible(False)
axes[0].spines["right"].set_visible(False)

# Plotting bars for positive values (Growth Rate)
bars2 = axes[1].barh(
    companies,
    growth_rate,
    color=pos_colors,
    edgecolor="white",
    height=0.5,
    xerr=growth_error,
    capsize=3,
)
axes[1].set_xlabel(xlabels[1])
axes[1].set_title(titles[1], fontsize=14)
axes[1].invert_yaxis()
axes[1].set_xlim(xlims[1])
axes[1].xaxis.grid(True, linestyle='--', linewidth=0.7)
axes[1].spines["top"].set_visible(False)
axes[1].spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_93.pdf", bbox_inches="tight")

