
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for Quality of Life Index in different neighborhoods
neighborhoods = ["Downtown", "Suburb", "Countryside"]
qol_healthcare = [0.70, 0.85, 0.60]  # Quality of Healthcare scores
qol_education = [0.65, 0.80, 0.55]  # Quality of Education scores
qol_recreation = [0.60, 0.75, 0.50]  # Quality of Recreation scores
error = [0.05, 0.04, 0.05]  # Error margins for the QoL scores

# Bar positions
x = np.arange(len(neighborhoods))
width = 0.25  # width of the bars

labels = ["Healthcare", "Education", "Recreation"]
ylabel = "Quality of Life Index"
title = "Quality of Life Index by Neighborhood"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))
bars1 = ax.bar(
    x - width,
    qol_healthcare,
    width,
    label=labels[0],
    color="skyblue",
    yerr=error,
    capsize=5,
    hatch="//",
)
bars2 = ax.bar(
    x,
    qol_education,
    width,
    label=labels[1],
    color="lightgreen",
    yerr=error,
    capsize=5,
    hatch="\\",
)
bars3 = ax.bar(
    x + width,
    qol_recreation,
    width,
    label=labels[2],
    color="lightcoral",
    yerr=error,
    capsize=5,
    hatch="--",
)

# Adding text for labels, title, and custom x-axis tick labels
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(neighborhoods)
ax.axhline(0, color="gray", linewidth=0.8)
ax.legend()

# Adding grid for better readability
ax.yaxis.grid(True, linestyle='--', alpha=0.7)

# Adding data labels on the bars
def add_labels(bars):
    for bar in bars:
        height = bar.get_height()
        ax.annotate(
            f"{height:.2f}",
            xy=(
                bar.get_x() + bar.get_width() / 2,
                (
                    height + error[bars.index(bar)]
                    if height > 0
                    else height - error[bars.index(bar)]
                ),
            ),
            xytext=(
                0,
                3 if height > 0 else -12,
            ),  # move text up or down based on bar direction
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

add_labels(bars1)
add_labels(bars2)
add_labels(bars3)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("errorbar_95.pdf", bbox_inches="tight")
