
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
entities = ["Paris", "New York", "Tokyo", "Sydney"]
protocols = [
    "Attraction Diversity",
    "Accommodation Quality",
    "Cost Efficiency",
    "Safety",
    "Accessibility",
    "Environmental Sustainability",
]
# Simulated mean scores for different protocols
tourism_scores_means = np.array(
    [
        [80, 85, 75, 90, 70, 65],  # Paris
        [75, 70, 65, 85, 90, 60],  # New York
        [85, 80, 70, 95, 60, 70],  # Tokyo
        [70, 75, 80, 80, 85, 75],  # Sydney
    ]
)

# Simulated standard deviations for scores (more variability)
tourism_scores_std = np.array(
    [
        [5, 6, 7, 4, 8, 5],  # Paris
        [7, 5, 6, 8, 5, 7],  # New York
        [5, 7, 8, 6, 7, 6],  # Tokyo
        [6, 8, 5, 7, 6, 5],  # Sydney
    ]
)

xlabel = "Tourist Destinations"
ylabel = "Assessment Scores (%)"
ylim = [50, 110]
legendtitle = "Evaluation Criteria"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6))

# Vibrant color palette for tourism theme
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0", "#ffb3e6"]

# Bar width and positions
bar_width = 0.12

# Positions of the bar groups
r = np.arange(len(entities))

# Drawing bars for different protocols
for i in range(len(protocols)):
    ax.bar(
        r + i * bar_width,
        tourism_scores_means[:, i],
        yerr=tourism_scores_std[:, i],
        width=bar_width,
        label=protocols[i],
        capsize=4,
        color=colors[i],
        edgecolor="black",
    )

# Set x-axis labels and axis properties
ax.set_xlabel(xlabel)
ax.set_xticks(r + bar_width * (len(protocols) / 2))
ax.set_xticklabels(entities)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)
ax.set_title("Tourism Destination Assessment", fontsize=16)

# Customize the legend
ax.legend(loc="lower center", bbox_to_anchor=(0.5, -0.3), title=legendtitle, ncol=3)

# Add gridlines for better readability
ax.grid(True, linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_97.pdf", bbox_inches="tight")
